<?php

header('Content-Type: application/xml');

$files = array(
"/Aerosmith/Janie's Got A Gun.mp3"
"/Beatles/Yesterday.mp3",
"/Blink 182/Cheshire Cat/Carousel.mp3"
);

$count = count($files);
$start = rand(0, max(0,$count-100));

print <<<XML
<rss version="2.0">
    <channel>
        <title>Miscellaneous</title> 
        <link>http://domain.com/music.xml.php</link>
        <description></description>
        <language>en-us</language>
        <image>
            <url>http://domain.com/icon/Aerosmith.jpg</url>
            <title>Aerosmith</title>
        </image>
XML;

for ($i = $start; $i < $start+100 && $i < $count; $i++)
{
    preg_replace("#^/(.*)/(.*).mp3$#ie", 'list($album, $song) = array("$1", "$2");', $files[$i]);
    $album = stripslashes(str_replace('&', '&amp;', $album));
    $song = stripslashes(str_replace('&', '&amp;', $song));
    $file = str_replace('&', '&amp;', str_replace(' ', '%20', $files[$i]));
    print <<<XML

        <item>
            <title>$album - $song</title>
            <description></description>
            <author>$album</author>
            <pubDate>Sat, 01 Jan 2000 00:00:00 +0000</pubDate>
            <enclosure url="http://domain.com/$file" type="audio/mp3" />
        </item>
XML;
}

print <<<XML

    </channel>
</rss>
XML;
