#include "Planet.h"

#define SQUARE(a) ((a)*(a))

using std::vector;

vector<Planet*> Planet::planets;

void Planet::clearAll()
{
    for (unsigned int i = 0; i < Planet::planets.size(); i++)
    { delete Planet::planets[i]; }
    Planet::planets.clear();
}

void Planet::finishAll()
{
    for (unsigned int i = 0; i < Planet::planets.size(); i++)
    { Planet::planets[i]->finish(); }
}

Planet::Planet(float mass, float x, float y, float speed, float direction)
{
    this->done = false;

    this->setMass(mass);
    this->setX(x);
    this->setY(y);

    this->setSpeed(speed);
    this->setDirection(direction);
}

void Planet::unfinish()
{ this->done = false; }
void Planet::finish()
{ this->done = true; }
bool Planet::finished()
{ return this->done; }

void Planet::setMass(float mass)
{ this->mass = mass < 0 ? 0 : mass; }
float Planet::getMass()
{ return this->mass; }

void Planet::planMoving(float x, float y)
{ this->newX = this->x + x; this->newY = this->y + y; }
void Planet::finishMoving()
{
    // Calculate new direction
    // Swap Y and X, since 0° is north, not east
    this->direction = atan2(this->newX - this->x, this->newY - this->y);
    if (this->direction < 0)
    { this->direction += 2*GU_PI; }

    // New speed
    this->speed = sqrtf(SQUARE(this->newX - this->x) + SQUARE(this->newY - this->y));

    // Finish moving :)
    this->x = this->newX; this->y = this->newY;
}

void Planet::setX(float x)
{ this->x = x; }
void Planet::setY(float y)
{ this->y = y; }
float Planet::getX()
{ return this->x; }
float Planet::getY()
{ return this->y; }

void Planet::setSpeed(float speed)
{ this->speed = speed < 0 ? 0 : speed; }
float Planet::getSpeed()
{ return this->speed; }

void Planet::setDirection(float direction)
{
    if (direction < 0 || direction >= 2*GU_PI)
    { this->direction = 0; }
    else
    { this->direction = direction; }
}
float Planet::getDirection()
{ return this->direction; }
