#include "message.h"

static void showDialog(pspUtilityMsgDialogParams *dialog, void(callback)());
static void configDialog(pspUtilityMsgDialogParams *dialog, size_t dialog_size);

pspUtilityMsgDialogParams dialog;

extern unsigned int __attribute__((aligned(16))) guList[262144];

void showMessage(char *message, short isQuestion, void(callback)())
{
    configDialog(&dialog, sizeof(dialog));

    dialog.mode = PSP_UTILITY_MSGDIALOG_MODE_TEXT;
    dialog.options = PSP_UTILITY_MSGDIALOG_OPTION_TEXT;

    if (isQuestion)
    { dialog.options |= PSP_UTILITY_MSGDIALOG_OPTION_YESNO_BUTTONS | PSP_UTILITY_MSGDIALOG_OPTION_DEFAULT_NO; }

    strncpy(dialog.message, message, 512);

    showDialog(&dialog, callback);
}

void showError(unsigned int error, void(callback)())
{
    configDialog(&dialog, sizeof(dialog));

    dialog.mode = PSP_UTILITY_MSGDIALOG_MODE_ERROR;
    dialog.options = PSP_UTILITY_MSGDIALOG_OPTION_ERROR;
    dialog.errorValue = error;

    showDialog(&dialog, callback);
}

// See messageCallback() for the bare minimum callback
static void showDialog(pspUtilityMsgDialogParams *dialog, void(callback)())
{
    sceUtilityMsgDialogInitStart(dialog);

    while (1)
    {
        callback();

        switch (sceUtilityMsgDialogGetStatus())
        {
            case PSP_UTILITY_DIALOG_VISIBLE:
                sceUtilityMsgDialogUpdate(1);
                break;
            case PSP_UTILITY_DIALOG_QUIT:
                sceUtilityMsgDialogShutdownStart();
                break;
            case PSP_UTILITY_DIALOG_NONE:
                return;
        }

        graphicsFlush();
    }
}

static void configDialog(pspUtilityMsgDialogParams *dialog, size_t dialog_size)
{
    memset(dialog, 0, dialog_size);

    dialog->base.size = dialog_size;
    sceUtilityGetSystemParamInt(PSP_SYSTEMPARAM_ID_INT_LANGUAGE, &dialog->base.language); // Prompt language
    sceUtilityGetSystemParamInt(PSP_SYSTEMPARAM_ID_INT_UNKNOWN, &dialog->base.buttonSwap); // X/O button swap

    dialog->base.soundThread    = 0x10;
    dialog->base.graphicsThread = 0x11;
    dialog->base.fontThread     = 0x12;
    dialog->base.accessThread   = 0x13;
}

void messageCallback()
{
    sceGuStart(GU_DIRECT, guList);

    sceGuClear(GU_COLOR_BUFFER_BIT | GU_DEPTH_BUFFER_BIT);

    sceGuFinish();
    sceGuSync(0, 0);
}
