#ifndef GRAPHICS_H
#define GRAPHICS_H
#include <pspkernel.h>
#include <pspdisplay.h>
#include <pspdebug.h>
#include <pspgu.h>

#include <string.h>

#include "psp.h"

void graphicsInit();
void graphicsFlush();
void drawPixel(float x, float y, unsigned int color);
void drawLine(float sx, float sy, float dx, float dy, unsigned int color);
void drawTriangle(float sx, float sy, float dx, float dy, float lx, float ly, unsigned int color);
void drawBox(float sx, float sy, float dx, float dy, unsigned int color);

typedef u32 Vram;

typedef struct
{
    unsigned int color;
    float x, y, z;
} Vertex;
#endif
