#include "graphics.h"

static Vram *getVram(int width, int height, int colorDepth);

Vram *dispBuffer = NULL; Vram *drawBuffer = NULL;
static int vramAllocated = 0;
unsigned int __attribute__((aligned(16))) guList[262144];

void graphicsInit()
{
    dispBuffer = getVram(BUFFER, SCREEN_HEIGHT, 4);
    drawBuffer = getVram(BUFFER, SCREEN_HEIGHT, 4);
    memset(guList, 0, sizeof(int[262144]));

    pspDebugScreenInit();
    pspDebugScreenSetOffset((int)dispBuffer);

    sceGuInit();

    sceGuStart(GU_DIRECT, guList);
    sceGuDrawBuffer(GU_PSM_8888, drawBuffer, BUFFER);
    sceGuDispBuffer(SCREEN_WIDTH, SCREEN_HEIGHT, dispBuffer, BUFFER);

    sceGuClear(GU_COLOR_BUFFER_BIT);
    sceGuOffset(2048 - (SCREEN_WIDTH / 2), 2048 - (SCREEN_HEIGHT / 2));
    sceGuViewport(2048, 2048, SCREEN_WIDTH, SCREEN_HEIGHT);
    sceGuDepthRange(65535, 0);
    // Don't render polygons outside the screen
    sceGuScissor(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
    sceGuEnable(GU_SCISSOR_TEST);
    //Only display polygons facing user (defined clockwise)
    //sceGuEnable(GU_CULL_FACE);
    sceGuFinish();
    sceGuSync(0, 0);

    sceGuDisplay(GU_TRUE);
}

static Vram *getVram(int width, int height, int colorDepth)
{
    Vram *vram = (Vram *)vramAllocated;
    vramAllocated += width*height*colorDepth;

    return vram;
}

void graphicsFlush()
{
    sceGuFinish();
    sceGuSync(0, 0);
    sceDisplayWaitVblankStart();
    dispBuffer = drawBuffer;
    drawBuffer = sceGuSwapBuffers();
    pspDebugScreenSetOffset((int)drawBuffer);
}

// Drawing functions
void drawPixel(float x, float y, unsigned int color)
{
    Vertex *vertices = (Vertex *)sceGuGetMemory(sizeof(Vertex));
    memset(vertices, 0, sizeof(Vertex));
    vertices[0].color = color;
    vertices[0].x = x;
    vertices[0].y = y;

    sceGuDrawArray(GU_POINTS, GU_COLOR_8888 | GU_VERTEX_32BITF | GU_TRANSFORM_2D, 1, 0, vertices);
}

void drawLine(float sx, float sy, float dx, float dy, unsigned int color)
{
    Vertex *vertices = (Vertex *)sceGuGetMemory(2*sizeof(Vertex));
    memset(vertices, 0, 2*sizeof(Vertex));
    vertices[0].color = color;
    vertices[0].x = sx;
    vertices[0].y = sy;
    vertices[1].color = color;
    vertices[1].x = dx;
    vertices[1].y = dy;

    sceGuDrawArray(GU_LINES, GU_COLOR_8888 | GU_VERTEX_32BITF | GU_TRANSFORM_2D, 2, 0, vertices);
}

void drawTriangle(float sx, float sy, float mx, float my, float dx, float dy, unsigned int color)
{
    sceGuColor(color);
    Vertex *vertices = (Vertex *)sceGuGetMemory(3*sizeof(Vertex));
    memset(vertices, 0, 3*sizeof(Vertex));
    vertices[0].color = color;
    vertices[0].x = sx;
    vertices[0].y = sy;
    vertices[1].color = color;
    vertices[1].x = mx;
    vertices[1].y = my;
    vertices[2].color = color;
    vertices[2].x = dx;
    vertices[2].y = dy;

    sceGuDrawArray(GU_TRIANGLES, GU_COLOR_8888 | GU_VERTEX_32BITF | GU_TRANSFORM_2D, 3, 0, vertices);
}

void drawBox(float sx, float sy, float dx, float dy, unsigned int color)
{
    sceGuColor(color);

    Vertex *vertices = (Vertex *)sceGuGetMemory(2*sizeof(Vertex));
    memset(vertices, 0, 2*sizeof(Vertex));
    vertices[0].color = color;
    vertices[0].x = sx;
    vertices[0].y = sy;
    vertices[1].color = color;
    vertices[1].x = dx;
    vertices[1].y = dy;

    sceGuDrawArray(GU_SPRITES, GU_COLOR_8888 | GU_VERTEX_32BITF | GU_TRANSFORM_2D, 2, 0, vertices);
}
