#include <stdlib.h>
#include <math.h>
#include "include/callback.h"

typedef struct ShortList
{
    short value;
    struct ShortList *next;
} ShortList;

typedef struct
{
    unsigned int size;
    unsigned int frequency;
    float decay;
    char note[4];
    ShortList *samples; // linked list implemented as array
    ShortList *sampleArray; // start of array (for free()'ing)
} SoundBuffer;

typedef struct SoundBufferList
{
    SoundBuffer *value;
    struct SoundBufferList *next;
} SoundBufferList;

typedef struct
{
    unsigned int size;
    SoundBufferList *buffers;
} Chord;

SoundBuffer *newSoundBuffer(unsigned int size, unsigned int frequency, char *note);
void freeSoundBuffer(SoundBuffer *soundBuffer);

Chord *newChord();
SoundBuffer *addSoundBufferToChord(Chord *chord, unsigned int size, unsigned int frequency, char *note);
void deleteSoundBufferFromChord(Chord *chord, SoundBuffer *soundBuffer);
void freeChord(Chord *chord);
